<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

namespace Glpi\Exception\Http;

trait HttpExceptionTrait
{
    private ?string $message_to_display = null;

    private ?string $link_text = null;

    private ?string $link_url = null;

    /**
     * Get the message to display.
     */
    public function getMessageToDisplay(): ?string
    {
        return $this->message_to_display;
    }

    /**
     * Define the message to display.
     */
    public function setMessageToDisplay(?string $message): void
    {
        $this->message_to_display = $message;
    }

    /**
     * Get the specific link text.
     */
    public function getLinkText(): ?string
    {
        return $this->link_text;
    }

    /**
     * Define the specific link text.
     */
    public function setLinkText(?string $text): void
    {
        $this->link_text = $text;
    }

    /**
     * Get the specific link URL.
     */
    public function getLinkUrl(): ?string
    {
        return $this->link_url;
    }

    /**
     * Define the specific link URL.
     */
    public function setLinkUrl(?string $url): void
    {
        $this->link_url = $url;
    }
}
